package jcircus.util;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.czt.circus.ast.ProcessPara;
import net.sourceforge.czt.z.ast.VarDecl;
import net.sourceforge.czt.z.ast.Expr;

/**
 * ProcInfo.java
 *
 * Contains the information of a process definition.
 *
 * @author Angela Freitas
 */
public class ProcInfo {

    /** Process name */
    private String processName;
    
    /** Process definition */
    private ProcessPara processPara;
    
    /** Code resulting from the translation of the process definition */
    private String code;
    
    /** Normalized variable declarations. That is, each VarDecl declares at most
        one variable */
    private List<VarDecl> parameters;
    
    /** Code for the parameters */
    private List<String> codeForActuals;
    
    /** Flag indicating if a main is to be created for the process or not. */
    private boolean createMain;
    
    
    /**
     * Constructor.
     */
    public ProcInfo(String processName, ProcessPara processPara, String code,
            List<VarDecl> parameters, boolean createMain) {
        this.processName = processName;
        this.processPara = processPara;
        this.code = code;
        this.parameters = parameters;
        this.codeForActuals = new ArrayList();
        this.createMain = createMain;
    }
    
    public String getProcessName() {
        return this.processName;
    }
    
    public ProcessPara getProcessPara() {
        return this.processPara;
    }

    public List getParameters() {
        return this.parameters;
    }
    
    public List<String> getCodeForActuals() {
        return this.codeForActuals;
    }
    
    public boolean getCreateMain() {
        return this.createMain;
    }
    
    public String getCode() {
        return this.code;
    }

    public void setCreateMain(boolean createMain) {
        this.createMain = createMain;
    }

}
